(*| 21:15 29/04/1990 *)
PROGRAM ZIPCAT;

USES Dos;

CONST
  ZDPakSize =30;
  ZDLocalSig=$04034B50;
  ZDCenSig=$02014B50;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];
  ZDClass=(ByteZDClass,StrucZDClass);
  ZipDirType= RECORD
                CASE ZDClass OF
                  ByteZDClass:(ZDByte     : ARRAY[0..ZDPakSize-1] OF Byte);
                  StrucZDClass:(ZDSignatur: LongInt;
                                ZDExtVer  : Word;
                                ZDFlag    : Word;
                                ZDStyle   : Word;
                                ZDTimeDate: LongInt;

(*                              ZDTime    : Word;
                                ZDDate    : Word;*)

                                ZDCrc     : LongInt;
                                ZDSizeNow : LongInt;
                                ZDSize    : LongInt;
                                ZDNameLen : Word;
                                ZDExtraLen: Word);
              END;

VAR
  FileName:FNameType;

FUNCTION IntToString(Num, Width : Integer) : LineString;
{ Changes an integer into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width, TempString);
  IntToString := TempString;
END; { IntToString }

FUNCTION IntToPadString(Num, Width : Integer) : LineString;
{ Changes an integer into a string and pads it with a zero on the left if
  it is less than 10 }
BEGIN
  IF Num < 10 THEN
    IntToPadString := '0' + IntToString(Num, Width)
  ELSE
    IntToPadString := IntToString(Num, Width);
END; { IntToString }

FUNCTION FileDateString(DateInt :LongInt):LineString;
VAR Date:DateTime;
BEGIN
  UnpackTime(DateInt,Date);
  WITH Date DO
    FileDateString:=IntToString(Day,2) + '/' +
                    IntToPadString(Month,1) + '/' +
                    IntToString(Year MOD 100,2);
END;  { FileDateString }

FUNCTION FileTimeString(TimeInt :LongInt):LineString;
VAR Time:DateTime;
BEGIN
  UnpackTime(TimeInt,Time);
  WITH Time DO
    FileTimeString:=IntToString(Hour,2) + ':' +
                    IntToPadString(Min,1) + ':' +
                    IntToPadString(Sec,1);
END; { FileTimeString }

PROCEDURE WriteHex(N,Size: LongInt);

Var
  I,J,K,Mask: LongInt;

BEGIN
  J:=(Size-1)*4;
  Mask:=15 SHL J;
  FOR I:=1 TO Size DO
    BEGIN
      K:=(N AND Mask) SHR J;
      IF K > 9 THEN Write(Chr(K+55)) ELSE Write(K);
      Mask:=Mask SHR 4;
      J:=J-4;
    END;
  Write(' ');
END;

PROCEDURE ShowZipDir(ArcName: FNameType);
VAR
  ArcFile: FILE OF Byte;
  FilePos,TotSize,TotSizeNow,TotFiles: LongInt;
  ZipDir:ZipDirType;

FUNCTION NextByte: Byte;
VAR NB:Byte;
BEGIN
  Read(ArcFile,NB);
  NextByte:=NB;
END;

FUNCTION NextWord: Word;
VAR NW:Word;
BEGIN
  NW:=NextByte;
  NextWord:=NW+(NextByte SHL 8);
END;

FUNCTION NextLongInt: LongInt;
VAR NLI:LongInt;
BEGIN
  NLI:=NextWord;
  NextLongInt:=NLI+(LongInt(NextWord) SHL 16);
END;

PROCEDURE ShowInfo(ZipDir:ZipDirType);
VAR
  DT:LongInt;
  I:Integer;
  ThisName:FNameType;
BEGIN
  WITH ZipDir DO BEGIN
    ThisName:='';
    FOR I:=1 TO ZDNameLen DO
      ThisName:=ThisName+CHR(NextByte);
    DT:=ZDTimeDate;
    Write(ThisName:12,' ',ZDSize:7,' ',ZDStyle,' ',ZDSizeNow:6,
                      ' ',100-((ZDSizeNow*100) DIV ZDSize):3,'%',
                      ' ',FileDateString(DT),
                      ' ',FileTimeString(DT),' ');
    WriteHex(ZDCrc,8);
    Writeln;
  END;
END;

PROCEDURE NextEntry(VAR ZipDir:ZipDirType);
VAR
  B:Byte;
  I:Integer;
  W:Word;
BEGIN
  WITH ZipDir DO BEGIN
    Seek(ArcFile,FilePos);
    FOR I:=0 TO ZDPakSize-1 DO
      ZDByte[I]:=NextByte;
    IF ZDSignatur = ZDLocalSig THEN BEGIN
      FilePos:=FilePos+ZDSizeNow+ZDNameLen+ZDExtraLen+ZDPakSize;
      INC(TotFiles);
      TotSizeNow:=TotSizeNow+ZDSizeNow;
      TotSize:=TotSize+ZDSize;
    END;
  END;
END;

BEGIN
  ASSIGN(ArcFile,ArcName);
{$I-}
  RESET(ArcFile);
{$I+}
  IF IOResult<>0 THEN
    Writeln('Unable to open ',ArcName)
  ELSE WITH ZipDir DO BEGIN
    Writeln('FileName','Length':12,'Size':8,'Ratio':7,
               'Date':7,'Time':8,'CRC':6);
    Writeln;
    FilePos:=0;
    TotFiles:=0;
    TotSize:=0;
    TotSizeNow:=0;
    REPEAT
      NextEntry(ZipDir);
     IF ZDSignatur = ZDLocalSig THEN
        ShowInfo(ZipDir);
    UNTIL ZDSignatur <> ZDLocalSig;
    Writeln('----','------':16,'------':9,'----':5);
    Writeln(TotFiles:4,TotSize:16,TotSizeNow:9,
            100-((TotSizeNow*100) DIV TotSize):4,'%');
    Close(ArcFile);
  END;
END;  { ShowZipDir }

PROCEDURE SetFileName;
BEGIN
  IF ParamCount > 0 THEN
    FileName:=ParamStr(1)
  ELSE BEGIN
    Write('Name of ZIP file : ');
    Readln(FileName);
  END;
  IF POS('.',FileName)=0 THEN
    FileName:=FileName+'.ZIP';
END;  { SetFileName }

BEGIN
  Writeln('Zip Directory Program by B Whitnall, V1.0');
  Writeln;
  SetFileName;
  Writeln(FileName);
  Writeln;
  ShowZipDir(FileName);
END.
